/*
 * PercentTableView.cpp
 *
 *  Created on: 15.04.2013
 *      Author: stefan.detter
 */

#include "PercentTableView.h"

PercentTableView::PercentTableView(QWidget* parent)
	: QTableView(parent)
{
}

PercentTableView::~PercentTableView()
{
}

void PercentTableView::setModel ( QAbstractItemModel * model )
{
	QTableView::setModel(model);

	connect(model,	SIGNAL(columnsInserted ( const QModelIndex &, int, int)),
			this,	  SLOT(columnsChanged  ( )));
	connect(model,	SIGNAL(columnsRemoved  ( const QModelIndex &, int, int)),
			this,	  SLOT(columnsChanged  ( )));
	connect(model,	SIGNAL(rowsInserted	   ( const QModelIndex &, int, int)),
			this,	  SLOT(rowsChanged     ( )));
	connect(model,	SIGNAL(rowsRemoved     ( const QModelIndex &, int, int)),
			this,	  SLOT(rowsChanged     ( )));
}

void PercentTableView::resizeEvent ( QResizeEvent * event )
{
	QTableView::resizeEvent(event);
	columnsChanged();
	rowsChanged();
}

void PercentTableView::columnsChanged (  )
{
	if(this->model()->columnCount() == 0)
		return;

	int width = this->size().width();
	int elemWidth = width / this->model()->columnCount();
	for(int i = 0; i < this->model()->columnCount(); i++)
	{
		this->setColumnWidth(i, elemWidth);
	}
}

void PercentTableView::rowsChanged (  )
{
	if(this->model()->rowCount() == 0)
		return;

	int height = this->size().height();
	int elemHeight = height / this->model()->rowCount();
	for(int i = 0; i < this->model()->rowCount(); i++)
	{
		this->setRowHeight(i, elemHeight);
	}
}
